
    // ===========================================
    // ===========================================
    //            Color Picker
    // ===========================================
    // ===========================================

    // Color palette
    var demoPalette = [
          ["#000","#444","#666","#999","#ccc","#eee","#f3f3f3","#fff"],
          ["#f00","#f90","#ff0","#0f0","#0ff","#00f","#90f","#f0f"],
          ["#f4cccc","#fce5cd","#fff2cc","#d9ead3","#d0e0e3","#cfe2f3","#d9d2e9","#ead1dc"],
          ["#ea9999","#f9cb9c","#ffe599","#b6d7a8","#a2c4c9","#9fc5e8","#b4a7d6","#d5a6bd"],
          ["#e06666","#f6b26b","#ffd966","#93c47d","#76a5af","#6fa8dc","#8e7cc3","#c27ba0"],
          ["#c00","#e69138","#f1c232","#6aa84f","#45818e","#3d85c6","#674ea7","#a64d79"],
          ["#900","#b45f06","#bf9000","#38761d","#134f5c","#0b5394","#351c75","#741b47"],
          ["#600","#783f04","#7f6000","#274e13","#0c343d","#073763","#20124d","#4c1130"]
    ]

    // ===========================================
    // ===========================================
    //            Icon Picker
    // ===========================================
    // ===========================================

    // Icont Picker
    var icm_icons = {
        'Web Applications' : [57436, 57437, 57438, 57439, 57524, 57525, 57526, 57527, 57528, 57531, 57532, 57533, 57534, 57535, 57536, 57537, 57541, 57545, 57691, 57692],
        'Business Icons' : [57347, 57348, 57375, 57376, 57377, 57379, 57403, 57406, 57432, 57433, 57434, 57435, 57450, 57453, 57456, 57458, 57460, 57461, 57463],
        'eCommerce' : [57392, 57397, 57398, 57399, 57402],
        'Currency Icons' : [],
        'Form Control Icons' : [57383, 57384, 57385, 57386, 57387, 57388, 57484, 57594, 57595, 57600, 57603, 57604, 57659, 57660, 57693],
        'User Action & Text Editor' : [57442, 57443, 57444, 57445, 57446, 57447, 57472, 57473, 57474, 57475, 57476, 57477, 57539, 57662, 57668, 57669, 57670, 57671, 57674, 57675, 57688, 57689],
        'Charts and Codes' : [57493],
        'Attentive' : [57543, 57588, 57590, 57591, 57592, 57593, 57596],
        'Multimedia Icons' : [57356, 57357, 57362, 57363, 57448, 57485, 57547, 57548, 57549, 57605, 57606, 57609, 57610, 57611, 57614, 57617, 57618, 57620, 57621, 57622, 57623, 57624, 57625, 57626],
        'Location and Contact' : [57344, 57345, 57346, 57404, 57405, 57408, 57410, 57411, 57413, 57414, 57540],
        'Date and Time' : [57415, 57416, 57417, 57421, 57422, 57423],
        'Devices' : [57359, 57361, 57364, 57425, 57426, 57430],
        'Tools' : [57349, 57350, 57352, 57355, 57365, 57478, 57479, 57480, 57481, 57482, 57483, 57486, 57487, 57488, 57663, 57664],
        'Social and Networking' : [57694, 57700, 57701, 57702, 57703, 57704, 57705, 57706, 57707, 57709, 57710, 57711, 57717, 57718, 57719, 57736, 57737, 57738, 57739, 57740, 57741, 57742, 57746, 57747, 57748, 57755, 57756, 57758, 57759, 57760, 57761, 57763, 57764, 57765, 57766, 57767, 57776],
        'Brands' : [57743, 57750, 57751, 57752, 57753, 57754, 57757, 57773, 57774, 57775, 57789, 57790, 57792, 57793],
        'Files & Documents' : [57378, 57380, 57381, 57382, 57390, 57391, 57778, 57779, 57780, 57781, 57782, 57783, 57784, 57785, 57786, 57787],
        'Like & Dislike Icons' : [57542, 57544, 57550, 57551, 57552, 57553, 57554, 57555, 57556, 57557],
        'Emoticons' : [57558, 57559, 57560, 57561, 57562, 57563, 57564, 57565, 57566, 57567, 57568, 57569, 57570, 57571, 57572, 57573, 57574, 57575, 57576, 57577, 57578, 57579, 57580, 57581, 57582, 57583],
        'Directional Icons' : [57584, 57585, 57586, 57587, 57631, 57632, 57633, 57634, 57635, 57636, 57637, 57638, 57639, 57640, 57641, 57642, 57643, 57644, 57645, 57646, 57647, 57648, 57649, 57650, 57651, 57652, 57653, 57654],
        'Other Icons' : [57351, 57353, 57354, 57358, 57360, 57366, 57367, 57368, 57369, 57370, 57371, 57372, 57373, 57374, 57389, 57393, 57394, 57395, 57396, 57400, 57401, 57407, 57409, 57412, 57418, 57419, 57420, 57424, 57427, 57428, 57429, 57431, 57440, 57441, 57449, 57451, 57452, 57454, 57455, 57457, 57459, 57462, 57464, 57465, 57466, 57467, 57468, 57469, 57470, 57471, 57489, 57490, 57491, 57492, 57494, 57495, 57496, 57497, 57498, 57499, 57500, 57501, 57502, 57503, 57504, 57505, 57506, 57507, 57508, 57509, 57510, 57511, 57512, 57513, 57514, 57515, 57516, 57517, 57518, 57519, 57520, 57521, 57522, 57523, 57529, 57530, 57538, 57546, 57589, 57597, 57598, 57599, 57601, 57602, 57607, 57608, 57612, 57613, 57615, 57616, 57619, 57627, 57628, 57629, 57630, 57655, 57656, 57657, 57658, 57661, 57665, 57666, 57667, 57672, 57673, 57676, 57677, 57678, 57679, 57680, 57681, 57682, 57683, 57684, 57685, 57686, 57687, 57690, 57695, 57696, 57697, 57698, 57699, 57708, 57712, 57713, 57714, 57715, 57716, 57720, 57721, 57722, 57723, 57724, 57725, 57726, 57727, 57728, 57729, 57730, 57731, 57732, 57733, 57734, 57735, 57744, 57745, 57749, 57762, 57768, 57769, 57770, 57771, 57772, 57777, 57788, 57791, 57794]
    };

    // Icont Picker TRANSFER IT TO CLASS AND USE icongenrate function 
    var icm_icons = {
        'Web Applications' : ['icomoon-box-add','icomoon-box-remove','icomoon-download','icomoon-upload','icomoon-list','icomoon-list2','icomoon-numbered-list','icomoon-menu','icomoon-menu2','icomoon-cloud-download','icomoon-cloud-upload','icomoon-download2','icomoon-upload2','icomoon-download3','icomoon-upload3','icomoon-globe','icomoon-attachment','icomoon-bookmark','icomoon-embed','icomoon-code'],
        'Business Icons' : ['icomoon-office','icomoon-newspaper','icomoon-book','icomoon-books','icomoon-library','icomoon-profile','icomoon-support','icomoon-address-book','icomoon-cabinet','icomoon-drawer','icomoon-drawer2','icomoon-drawer3','icomoon-bubble','icomoon-bubble2','icomoon-user','icomoon-user2','icomoon-user3','icomoon-user4','icomoon-busy'],
        'eCommerce' : ['icomoon-tag','icomoon-cart','icomoon-cart2','icomoon-cart3','icomoon-calculate'],
        'Currency Icons' : [],
        'Form Control Icons' : ['icomoon-copy','icomoon-copy2','icomoon-copy3','icomoon-paste','icomoon-paste2','icomoon-paste3','icomoon-settings','icomoon-cancel-circle','icomoon-checkmark-circle','icomoon-spell-check','icomoon-enter','icomoon-exit','icomoon-radio-checked','icomoon-radio-unchecked','icomoon-console'],
        'User Action & Text Editor' : ['icomoon-undo','icomoon-redo','icomoon-flip','icomoon-flip2','icomoon-undo2','icomoon-redo2','icomoon-zoomin','icomoon-zoomout','icomoon-expand','icomoon-contract','icomoon-expand2','icomoon-contract2','icomoon-link','icomoon-scissors','icomoon-bold','icomoon-underline','icomoon-italic','icomoon-strikethrough','icomoon-table','icomoon-table2','icomoon-indent-increase','icomoon-indent-decrease'],
        'Charts and Codes' : ['icomoon-pie'],
        'Attentive' : ['icomoon-eye-blocked','icomoon-warning','icomoon-question','icomoon-info','icomoon-info2','icomoon-blocked','icomoon-spam'],
        'Multimedia Icons' : ['icomoon-image','icomoon-image2','icomoon-play','icomoon-film','icomoon-forward','icomoon-equalizer','icomoon-brightness-medium','icomoon-brightness-contrast','icomoon-contrast','icomoon-play2','icomoon-pause','icomoon-forward2','icomoon-play3','icomoon-pause2','icomoon-forward3','icomoon-previous','icomoon-next','icomoon-volume-high','icomoon-volume-medium','icomoon-volume-low','icomoon-volume-mute','icomoon-volume-mute2','icomoon-volume-increase','icomoon-volume-decrease'],
        'Location and Contact' : ['icomoon-home','icomoon-home2','icomoon-home3','icomoon-phone','icomoon-phone-hang-up','icomoon-envelope','icomoon-location','icomoon-location2','icomoon-map','icomoon-map2','icomoon-flag'],
        'Date and Time' : ['icomoon-history','icomoon-clock','icomoon-clock2','icomoon-stopwatch','icomoon-calendar','icomoon-calendar2'],
        'Devices' : ['icomoon-camera','icomoon-headphones','icomoon-camera2','icomoon-keyboard','icomoon-screen','icomoon-tablet'],
        'Tools' : ['icomoon-pencil','icomoon-pencil2','icomoon-pen','icomoon-paint-format','icomoon-dice','icomoon-key','icomoon-key2','icomoon-lock','icomoon-lock2','icomoon-unlocked','icomoon-wrench','icomoon-cog','icomoon-cogs','icomoon-cog2','icomoon-filter','icomoon-filter2'],
        'Social and Networking' : ['icomoon-share','icomoon-googleplus','icomoon-googleplus2','icomoon-googleplus3','icomoon-googleplus4','icomoon-google-drive','icomoon-facebook','icomoon-facebook2','icomoon-facebook3','icomoon-twitter','icomoon-twitter2','icomoon-twitter3','icomoon-vimeo','icomoon-vimeo2','icomoon-vimeo3','icomoon-github','icomoon-github2','icomoon-github3','icomoon-github4','icomoon-github5','icomoon-wordpress','icomoon-wordpress2','icomoon-tumblr','icomoon-tumblr2','icomoon-yahoo','icomoon-soundcloud','icomoon-soundcloud2','icomoon-reddit','icomoon-linkedin','icomoon-lastfm','icomoon-lastfm2','icomoon-stumbleupon','icomoon-stumbleupon2','icomoon-stackoverflow','icomoon-pinterest','icomoon-pinterest2','icomoon-yelp'],
        'Brands' : ['icomoon-joomla','icomoon-apple','icomoon-finder','icomoon-android','icomoon-windows','icomoon-windows8','icomoon-skype','icomoon-paypal','icomoon-paypal2','icomoon-paypal3','icomoon-chrome','icomoon-firefox','icomoon-opera','icomoon-safari'],
        'Files & Documents' : ['icomoon-file','icomoon-file2','icomoon-file3','icomoon-file4','icomoon-folder','icomoon-folder-open','icomoon-file-pdf','icomoon-file-openoffice','icomoon-file-word','icomoon-file-excel','icomoon-file-zip','icomoon-file-powerpoint','icomoon-file-xml','icomoon-file-css','icomoon-html5','icomoon-html52'],
        'Like & Dislike Icons' : ['icomoon-eye','icomoon-eye2','icomoon-star','icomoon-star2','icomoon-star3','icomoon-heart','icomoon-heart2','icomoon-heart-broken','icomoon-thumbs-up','icomoon-thumbs-up2'],
        'Emoticons' : ['icomoon-happy','icomoon-happy2','icomoon-smiley','icomoon-smiley2','icomoon-tongue','icomoon-tongue2','icomoon-sad','icomoon-sad2','icomoon-wink','icomoon-wink2','icomoon-grin','icomoon-grin2','icomoon-cool','icomoon-cool2','icomoon-angry','icomoon-angry2','icomoon-evil','icomoon-evil2','icomoon-shocked','icomoon-shocked2','icomoon-confused','icomoon-confused2','icomoon-neutral','icomoon-neutral2','icomoon-wondering','icomoon-wondering2'],
        'Directional Icons' : ['icomoon-point-up','icomoon-point-right','icomoon-point-down','icomoon-point-left','icomoon-arrow-up-left','icomoon-arrow-up','icomoon-arrow-up-right','icomoon-arrow-right','icomoon-arrow-down-right','icomoon-arrow-down','icomoon-arrow-down-left','icomoon-arrow-left','icomoon-arrow-up-left2','icomoon-arrow-up2','icomoon-arrow-up-right2','icomoon-arrow-right2','icomoon-arrow-down-right2','icomoon-arrow-down2','icomoon-arrow-down-left2','icomoon-arrow-left2','icomoon-arrow-up-left3','icomoon-arrow-up3','icomoon-arrow-up-right3','icomoon-arrow-right3','icomoon-arrow-down-right3','icomoon-arrow-down3','icomoon-arrow-down-left3','icomoon-arrow-left3'],
        'Other Icons' : ['icomoon-quill','icomoon-blog','icomoon-droplet','icomoon-images','icomoon-music','icomoon-pacman','icomoon-spades','icomoon-clubs','icomoon-diamonds','icomoon-pawn','icomoon-bullhorn','icomoon-connection','icomoon-podcast','icomoon-feed','icomoon-stack','icomoon-tags','icomoon-barcode','icomoon-qrcode','icomoon-ticket','icomoon-coin','icomoon-credit','icomoon-notebook','icomoon-pushpin','icomoon-compass','icomoon-alarm','icomoon-alarm2','icomoon-bell','icomoon-print','icomoon-laptop','icomoon-mobile','icomoon-mobile2','icomoon-tv','icomoon-disk','icomoon-storage','icomoon-reply','icomoon-bubbles','icomoon-bubbles2','icomoon-bubbles3','icomoon-bubbles4','icomoon-users','icomoon-users2','icomoon-quotes-left','icomoon-spinner','icomoon-spinner2','icomoon-spinner3','icomoon-spinner4','icomoon-spinner5','icomoon-spinner6','icomoon-binoculars','icomoon-search','icomoon-hammer','icomoon-wand','icomoon-aid','icomoon-bug','icomoon-stats','icomoon-bars','icomoon-bars2','icomoon-gift','icomoon-trophy','icomoon-glass','icomoon-mug','icomoon-food','icomoon-leaf','icomoon-rocket','icomoon-meter','icomoon-meter2','icomoon-dashboard','icomoon-hammer2','icomoon-fire','icomoon-lab','icomoon-magnet','icomoon-remove','icomoon-remove2','icomoon-briefcase','icomoon-airplane','icomoon-truck','icomoon-road','icomoon-accessibility','icomoon-target','icomoon-shield','icomoon-lightning','icomoon-switch','icomoon-powercord','icomoon-signup','icomoon-tree','icomoon-cloud','icomoon-earth','icomoon-bookmarks','icomoon-notification','icomoon-close','icomoon-checkmark','icomoon-checkmark2','icomoon-minus','icomoon-plus','icomoon-stop','icomoon-backward','icomoon-stop2','icomoon-backward2','icomoon-first','icomoon-last','icomoon-eject','icomoon-loop','icomoon-loop2','icomoon-loop3','icomoon-shuffle','icomoon-tab','icomoon-checkbox-checked','icomoon-checkbox-unchecked','icomoon-checkbox-partial','icomoon-crop','icomoon-font','icomoon-text-height','icomoon-text-width','icomoon-omega','icomoon-sigma','icomoon-insert-template','icomoon-pilcrow','icomoon-lefttoright','icomoon-righttoleft','icomoon-paragraph-left','icomoon-paragraph-center','icomoon-paragraph-right','icomoon-paragraph-justify','icomoon-paragraph-left2','icomoon-paragraph-center2','icomoon-paragraph-right2','icomoon-paragraph-justify2','icomoon-newtab','icomoon-mail','icomoon-mail2','icomoon-mail3','icomoon-mail4','icomoon-google','icomoon-instagram','icomoon-feed2','icomoon-feed3','icomoon-feed4','icomoon-youtube','icomoon-youtube2','icomoon-lanyrd','icomoon-flickr','icomoon-flickr2','icomoon-flickr3','icomoon-flickr4','icomoon-picassa','icomoon-picassa2','icomoon-dribbble','icomoon-dribbble2','icomoon-dribbble3','icomoon-forrst','icomoon-forrst2','icomoon-deviantart','icomoon-deviantart2','icomoon-steam','icomoon-steam2','icomoon-blogger','icomoon-blogger2','icomoon-tux','icomoon-delicious','icomoon-xing','icomoon-xing2','icomoon-flattr','icomoon-foursquare','icomoon-foursquare2','icomoon-libreoffice','icomoon-css3','icomoon-IE','icomoon-IcoMoon']

    };
     
    var icm_icon_search = {
        'Web Applications' : ['Box add', 'Box remove', 'Download', 'Upload', 'List', 'List 2', 'Numbered list', 'Menu', 'Menu 2', 'Cloud download', 'Cloud upload', 'Download 2', 'Upload 2', 'Download 3', 'Upload 3', 'Globe', 'Attachment', 'Bookmark', 'Embed', 'Code'],
        'Business Icons' : ['Office', 'Newspaper', 'Book', 'Books', 'Library', 'Profile', 'Support', 'Address book', 'Cabinet', 'Drawer', 'Drawer 2', 'Drawer 3', 'Bubble', 'Bubble 2', 'User', 'User 2', 'User 3', 'User 4', 'Busy'],
        'eCommerce' : ['Tag', 'Cart', 'Cart 2', 'Cart 3', 'Calculate'],
        'Currency Icons' : [],
        'Form Control Icons' : ['Copy', 'Copy 2', 'Copy 3', 'Paste', 'Paste 2', 'Paste 3', 'Settings', 'Cancel circle', 'Checkmark circle', 'Spell check', 'Enter', 'Exit', 'Radio checked', 'Radio unchecked', 'Console'],
        'User Action & Text Editor' : ['Undo', 'Redo', 'Flip', 'Flip 2', 'Undo 2', 'Redo 2', 'Zoomin', 'Zoomout', 'Expand', 'Contract', 'Expand 2', 'Contract 2', 'Link', 'Scissors', 'Bold', 'Underline', 'Italic', 'Strikethrough', 'Table', 'Table 2', 'Indent increase', 'Indent decrease'],
        'Charts and Codes' : ['Pie'],
        'Attentive' : ['Eye blocked', 'Warning', 'Question', 'Info', 'Info 2', 'Blocked', 'Spam'],
        'Multimedia Icons' : ['Image', 'Image 2', 'Play', 'Film', 'Forward', 'Equalizer', 'Brightness medium', 'Brightness contrast', 'Contrast', 'Play 2', 'Pause', 'Forward 2', 'Play 3', 'Pause 2', 'Forward 3', 'Previous', 'Next', 'Volume high', 'Volume medium', 'Volume low', 'Volume mute', 'Volume mute 2', 'Volume increase', 'Volume decrease'],
        'Location and Contact' : ['Home', 'Home 2', 'Home 3', 'Phone', 'Phone hang up', 'Envelope', 'Location', 'Location 2', 'Map', 'Map 2', 'Flag'],
        'Date and Time' : ['History', 'Clock', 'Clock 2', 'Stopwatch', 'Calendar', 'Calendar 2'],
        'Devices' : ['Camera', 'Headphones', 'Camera 2', 'Keyboard', 'Screen', 'Tablet'],
        'Tools' : ['Pencil', 'Pencil 2', 'Pen', 'Paint format', 'Dice', 'Key', 'Key 2', 'Lock', 'Lock 2', 'Unlocked', 'Wrench', 'Cog', 'Cogs', 'Cog 2', 'Filter', 'Filter 2'],
        'Social and Networking' : ['Share', 'Googleplus', 'Googleplus 2', 'Googleplus 3', 'Googleplus 4', 'Google drive', 'Facebook', 'Facebook 2', 'Facebook 3', 'Twitter', 'Twitter 2', 'Twitter 3', 'Vimeo', 'Vimeo 2', 'Vimeo 3', 'Github', 'Github 2', 'Github 3', 'Github 4', 'Github 5', 'Wordpress', 'Wordpress 2', 'Tumblr', 'Tumblr 2', 'Yahoo', 'Soundcloud', 'Soundcloud 2', 'Reddit', 'Linkedin', 'Lastfm', 'Lastfm 2', 'Stumbleupon', 'Stumbleupon 2', 'Stackoverflow', 'Pinterest', 'Pinterest 2', 'Yelp'],
        'Brands' : ['Joomla', 'Apple', 'Finder', 'Android', 'Windows', 'Windows 8', 'Skype', 'Paypal', 'Paypal 2', 'Paypal 3', 'Chrome', 'Firefox', 'Opera', 'Safari'],
        'Files & Documents' : ['File', 'File 2', 'File 3', 'File 4', 'Folder', 'Folder open', 'File pdf', 'File openoffice', 'File word', 'File excel', 'File zip', 'File powerpoint', 'File xml', 'File css', 'Html 5', 'Html 52'],
        'Like & Dislike Icons' : ['Eye', 'Eye 2', 'Star', 'Star 2', 'Star 3', 'Heart', 'Heart 2', 'Heart broken', 'Thumbs up', 'Thumbs up 2'],
        'Emoticons' : ['Happy', 'Happy 2', 'Smiley', 'Smiley 2', 'Tongue', 'Tongue 2', 'Sad', 'Sad 2', 'Wink', 'Wink 2', 'Grin', 'Grin 2', 'Cool', 'Cool 2', 'Angry', 'Angry 2', 'Evil', 'Evil 2', 'Shocked', 'Shocked 2', 'Confused', 'Confused 2', 'Neutral', 'Neutral 2', 'Wondering', 'Wondering 2'],
        'Directional Icons' : ['Point up', 'Point right', 'Point down', 'Point left', 'Arrow up left', 'Arrow up', 'Arrow up right', 'Arrow right', 'Arrow down right', 'Arrow down', 'Arrow down left', 'Arrow left', 'Arrow up left 2', 'Arrow up 2', 'Arrow up right 2', 'Arrow right 2', 'Arrow down right 2', 'Arrow down 2', 'Arrow down left 2', 'Arrow left 2', 'Arrow up left 3', 'Arrow up 3', 'Arrow up right 3', 'Arrow right 3', 'Arrow down right 3', 'Arrow down 3', 'Arrow down left 3', 'Arrow left 3'],
        'Other Icons' : ['Quill', 'Blog', 'Droplet', 'Images', 'Music', 'Pacman', 'Spades', 'Clubs', 'Diamonds', 'Pawn', 'Bullhorn', 'Connection', 'Podcast', 'Feed', 'Stack', 'Tags', 'Barcode', 'Qrcode', 'Ticket', 'Coin', 'Credit', 'Notebook', 'Pushpin', 'Compass', 'Alarm', 'Alarm 2', 'Bell', 'Print', 'Laptop', 'Mobile', 'Mobile 2', 'Tv', 'Disk', 'Storage', 'Reply', 'Bubbles', 'Bubbles 2', 'Bubbles 3', 'Bubbles 4', 'Users', 'Users 2', 'Quotes left', 'Spinner', 'Spinner 2', 'Spinner 3', 'Spinner 4', 'Spinner 5', 'Spinner 6', 'Binoculars', 'Search', 'Hammer', 'Wand', 'Aid', 'Bug', 'Stats', 'Bars', 'Bars 2', 'Gift', 'Trophy', 'Glass', 'Mug', 'Food', 'Leaf', 'Rocket', 'Meter', 'Meter 2', 'Dashboard', 'Hammer 2', 'Fire', 'Lab', 'Magnet', 'Remove', 'Remove 2', 'Briefcase', 'Airplane', 'Truck', 'Road', 'Accessibility', 'Target', 'Shield', 'Lightning', 'Switch', 'Powercord', 'Signup', 'Tree', 'Cloud', 'Earth', 'Bookmarks', 'Notification', 'Close', 'Checkmark', 'Checkmark 2', 'Minus', 'Plus', 'Stop', 'Backward', 'Stop 2', 'Backward 2', 'First', 'Last', 'Eject', 'Loop', 'Loop 2', 'Loop 3', 'Shuffle', 'Tab', 'Checkbox checked', 'Checkbox unchecked', 'Checkbox partial', 'Crop', 'Font', 'Text height', 'Text width', 'Omega', 'Sigma', 'Insert template', 'Pilcrow', 'Lefttoright', 'Righttoleft', 'Paragraph left', 'Paragraph center', 'Paragraph right', 'Paragraph justify', 'Paragraph left 2', 'Paragraph center 2', 'Paragraph right 2', 'Paragraph justify 2', 'Newtab', 'Mail', 'Mail 2', 'Mail 3', 'Mail 4', 'Google', 'Instagram', 'Feed 2', 'Feed 3', 'Feed 4', 'Youtube', 'Youtube 2', 'Lanyrd', 'Flickr', 'Flickr 2', 'Flickr 3', 'Flickr 4', 'Picassa', 'Picassa 2', 'Dribbble', 'Dribbble 2', 'Dribbble 3', 'Forrst', 'Forrst 2', 'Deviantart', 'Deviantart 2', 'Steam', 'Steam 2', 'Blogger', 'Blogger 2', 'Tux', 'Delicious', 'Xing', 'Xing 2', 'Flattr', 'Foursquare', 'Foursquare 2', 'Libreoffice', 'Css 3', 'IE', 'IcoMoon']
    };


    // ===========================================
    // ===========================================
    //            Bootstrap Uploader
    // ===========================================
    // ===========================================
     // Modal template
    var modalTemplate = '<div class="modal-dialog modal-lg" role="document">\n' +
        '  <div class="modal-content">\n' +
        '    <div class="modal-header">\n' +
        '      <div class="kv-zoom-actions btn-group">{toggleheader}{fullscreen}{borderless}{close}</div>\n' +
        '      <h6 class="modal-title">{heading} <small><span class="kv-zoom-title"></span></small></h6>\n' +
        '    </div>\n' +
        '    <div class="modal-body">\n' +
        '      <div class="floating-buttons btn-group"></div>\n' +
        '      <div class="kv-zoom-body file-zoom-content"></div>\n' + '{prev} {next}\n' +
        '    </div>\n' +
        '  </div>\n' +
        '</div>\n';

    // Buttons inside zoom modal
    var previewZoomButtonClasses = {
        toggleheader: 'btn btn-default btn-icon btn-xs btn-header-toggle',
        fullscreen: 'btn btn-default btn-icon btn-xs',
        borderless: 'btn btn-default btn-icon btn-xs',
        close: 'btn btn-default btn-icon btn-xs'
    };

    // Icons inside zoom modal classes
    var previewZoomButtonIcons = {
        prev: '<i class="icon-arrow-left32"></i>',
        next: '<i class="icon-arrow-right32"></i>',
        toggleheader: '<i class="icon-menu-open"></i>',
        fullscreen: '<i class="icon-screen-full"></i>',
        borderless: '<i class="icon-alignment-unalign"></i>',
        close: '<i class="icon-cross3"></i>'
    };

    // File actions
    var fileActionSettings = {
        zoomClass: 'btn btn-link btn-xs btn-icon',
        zoomIcon: '<i class="icon-zoomin3"></i>',
        dragClass: 'btn btn-link btn-xs btn-icon',
        dragIcon: '<i class="icon-three-bars"></i>',
        removeClass: 'btn btn-link btn-icon btn-xs',
        removeIcon: '<i class="icon-trash"></i>',
        indicatorNew: '<i class="icon-file-plus text-slate"></i>',
        indicatorSuccess: '<i class="icon-checkmark3 file-icon-large text-success"></i>',
        indicatorError: '<i class="icon-cross2 text-danger"></i>',
        indicatorLoading: '<i class="icon-spinner2 spinner text-muted"></i>'
    };


    $('[data-popup=tooltip-custom]').tooltip({
        template: '<div class="tooltip"><div class="bg-teal"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div></div>'
    });
   


function showModal() {
    $('body').loadingModal({
                            position: 'auto',
                            text: 'Please Wait...',
                            color: '#fff',
                            opacity: '0.7',
                            backgroundColor: 'rgb(0,0,0)',
                            animation: 'threeBounce'
                          });
}

function hideModal(){
  $('body').loadingModal('destroy');
}

function round(value, decimals) {
    return Number(Math.round(value+'e'+decimals)+'e-'+decimals);
}

function insertTranslationFields(fields,typ=''){

  var lang_id     = $(`#${typ}translate_language_id_fk`).val();
  var lang_local  = $(`#${typ}translate_language_id_fk option:selected`).attr('data-local');


  

  var controlField =``;

  var exist = false;

  $(`#${typ}language_id\\[\\]`).each(function(){ 
      if( $(this).val()==lang_id) 
      {
        noty({    text: Translation('الحقول اضيفت مسبقا لهذه اللغة'),
                  type: 'error',
                  dismissQueue: true,
                  timeout: 2000,
                  layout: 'topRight'
            });  
        exist = true;
      }         
  });

  for (var key of Object.keys(fields)) { 
    // check for exsitance before insertion
    
    if (exist==false) {
      controlField = `
                        <div class="form-group has-feedback has-feedback-left col-lg-12 col-md-12 col-sm-12 col-xs-12">
                          <label class="control-label multi_lang">${fields[key]}  (${lang_local})</label>
                          <input type="text" placeholder="${fields[key]}  (${lang_local})" class="form-control multi_lang" name="${typ}${key}[]" id="${typ}${key}[]" >
                          <input type="hidden"  name="${typ}language_id[]" id="${typ}language_id[]" value="${lang_id}" >
                        </div>

                    `;
      $(`#${typ}translate-field`).append(controlField);
    }
    
  }


}

function initial_file_upload(id,no_of_files=1,file_preview){

  // find it in this page ==> assets/js/pages/uploader_bootstrap.js

  $(`#${id}`).fileinput('refresh',{

        uploadUrl: "#", // server upload action
        uploadAsync: true,
        // removeIcon: '<i class="icon-cross3"></i>',
        maxFileSize: 500,
        overwriteInitial: false,
        maxFilePreviewSize: 10240,
        maxFileCount: no_of_files,
        initialPreview: [
          file_preview,
        ],
        fileActionSettings: {
            removeIcon: '<i class="icon-bin"></i>',
            removeClass: 'btn btn-link btn-xs btn-icon',
            uploadIcon: '<i class="icon-upload"></i>',
            uploadClass: 'btn btn-link btn-xs btn-icon',
            zoomIcon: '<i class="icon-zoomin3"></i>',
            zoomClass: 'btn btn-link btn-xs btn-icon',
            indicatorNew: '<i class="icon-file-plus text-slate"></i>',
            indicatorSuccess: '<i class="icon-checkmark3 file-icon-large text-success"></i>',
            indicatorError: '<i class="icon-cross2 text-danger"></i>',
            indicatorLoading: '<i class="icon-spinner2 spinner text-muted"></i>',
        },
        layoutTemplates: {
            icon: '<i class="icon-file-check"></i>',
            modal: modalTemplate
        },
        allowedFileTypes: ["image", "video"],
        allowedFileExtensions: ["jpg", "jpeg", "png", "gif", "bmp", "svg", "webp"],
        // previewClass: "bg-info",
        initialCaption: "No file selected",
        previewZoomButtonClasses: previewZoomButtonClasses,
        previewZoomButtonIcons: previewZoomButtonIcons
    });

}

function initial_file_upload_small(id,no_of_files=1,file_preview){

  // find it in this page ==> assets/js/pages/uploader_bootstrap.js

  $(`#${id}`).fileinput('refresh',{

        uploadUrl: "#", // server upload action
        uploadAsync: true,
        // removeIcon: '<i class="icon-cross3"></i>',
        maxFileSize: 5000,
        overwriteInitial: false,
        maxFilePreviewSize: 10240,
        maxFileCount: no_of_files,
        
       layoutTemplates: {
        actionDrag: false,
       },
       
        allowedFileExtensions: ["jpg", "jpeg", "png", "gif", "bmp", "svg", "webp", "pdf"],
        // previewClass: "bg-info",
        initialCaption: "No file selected"
        
    });

}

function initial_icon(id){

    $(`#${id}`).fontIconPicker({
        source: icm_icons,
        searchSource: icm_icon_search,
        theme: 'fip-bootstrap',
        useAttribute: true,
        attributeName: 'data-icomoon',

        iconGenerator: function( icon ) {
            // source: icm_icons
            
            return '<i class="' + icon +'"></i>';
        }
    });

}

function initial_map(id){
  $(`#${id}`).locationpicker({
        location: {latitude: 36.38404046844331, longitude: 43.14167631406249}, 
        radius: 300,
        scrollwheel: false,
        inputBinding: {
            latitudeInput: $('#us3-lat'),
            longitudeInput: $('#us3-lon'),
            radiusInput: $('#us3-radius'),
            locationNameInput: $('#us3-address')        
        },
        enableAutocomplete: true,
        onchanged: function(currentLocation, radius, isMarkerDropped) {
            console.log("Location changed. New location (" + currentLocation.latitude + ", " + currentLocation.longitude + ")");
        }
  });




}

// ===========================================
// ===========================================
//            Color Picker
// ===========================================
// ===========================================
function initial_color_picker(id){

    $(".colorpicker").spectrum({
        // flat: true,
        showPalette: true,
        // showPaletteOnly: true,
        palette: demoPalette,
        showInput: true,
        showAlpha: true,
        allowEmpty: true,

        // togglePaletteOnly: true,
        // togglePaletteMoreText: 'More',
        //   togglePaletteLessText: 'Less',
        //   palette: demoPalette
    }); 
}

// ===========================================
// ===========================================
//          End Color Picker
// ===========================================
// ===========================================


// function get_user_permission(){

//   $.ajax({
//       url: "models/crul_system_permission.php",
//       type:"POST",
//       dataType : "JSON",
//       data: {
//               "type":"get_permission"},
//       complete:function(){
        
//       },
//       beforeSend:function(){
        
//       },
//       success: function(res) {

//         if(res.is_success == true){
           
          
//            user_permission=res.data;
          
//         }
        
//       }
//   });

// }

function check_permission(perm_id,date_=null){

    var ret = false;

    const includesone = user_permission.includes('1');
    console.log(includesone)
    if (includesone==true) {
        ret = true;
        return ret;
    }

    const includesTwenty = user_permission.includes('153');

    if (includesTwenty==true) {
        ret = true;
        return ret;
    }

  for (var i =0 ; i <user_permission.length ; i++) {
    if (perm_id == user_permission[i] || user_permission[i] =='1') {

        if (user_permission[i] =='1') {
            ret = true;
            break;
        }else{
            if (date_==null) {
                ret = true;
                break;
            }else{

                const includesTwenty = user_permission.includes('153');

                if (includesTwenty==true) {
                    ret = true;
                    break;
                }else{

                    const date1 = new Date(CURRENT_DATE);
                    // console.log(date1)
                    const date2 = new Date(date_);
                    // console.log(date_)
                    const diffTime = Math.abs(date2 - date1);
                    const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 72)); 
                    // console.log(diffDays)

                    if (diffDays<=1) {
                        ret = true;
                        break;
                    }else{
                        ret = false;
                        break;
                    }
                }
                
            }
        }
      
    }
  }
  
  return ret;
  

}



// Format Displaying Curreny for displaying only
function currency(cash,cur=DEFAULT_CURRENCY){
    var fx = 2;
    if (cur=='ar_IQ') {
        cur='د.ع';
        fx=0;
    }else{
        cur='$'
    }

    if(isNaN(cash) || cash == null || cash==0 || cash==undefined){
    return cur+" "+ 0;
    }else{
    var value = parseFloat(cash);
    var num =   value.toFixed(fx).replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,") + ' '+cur;
    return num;
    }

}

function currency_no_sign(cash,cur=''){
  if(isNaN(cash) || cash == null || cash==0 || cash==undefined){
    return cur+" "+ 0;
  }else{
    var value = parseFloat(cash);
    var num =   value.toFixed(2).replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,") + ' '+cur;
    return num;
  }

}



function getQueryVariable(variable) {
      var query = window.location.search.substring(1);
      var vars = query.split("&");
      for (var i=0;i<vars.length;i++) {
        var pair = vars[i].split("=");
        if (pair[0] == variable) {
          return pair[1];
        }
      }
      return 'not';
}

function get_Notify(){

  $.ajax({
      url: "models/crul_notify.php",
      type:"POST",
      dataType : "JSON",
      data: {"type":"get_notify"},
      complete:function(){
        
      },
      beforeSend:function(){
        
      },
      success: function(res) {

        if(res.is_success == true){
           
                   
          for (var i = 0; i < res.data.length; i++) {
            // opt += `<option value='${res.data[i].store_id}' >${res.data[i].store_name}</option>`;
          }
            

          $('#notify_total').html(res.data[0].cnt);

         

            
            

        }else{

          swal({
                  title: Translation("خطأ"),
                  text: Translation(res.data),
                  confirmButtonColor: "#2196F3",
                  type: "error"
              });

        }
        
      }
  });

}

function get_Notify_Detial(){

  $.ajax({
      url: "models/crul_notify.php",
      type:"POST",
      dataType : "JSON",
      data: {"type":"get_notify_all"},
      complete:function(){
        
      },
      beforeSend:function(){
        
      },
      success: function(res) {

        if(res.is_success == true){
           
           
            var opt =`<li class="dropdown-header text-danger text-center">${Translation('Transfer Section')}</li>`;

            for (var i = 0; i < res.data.length; i++) {
                

                var img ='assets/images/placeholder.jpg';
                if (res.data[i].profile_img !='' && res.data[i].profile_img !=null) {
                    img =res.data[i].profile_img;
                }
                opt += `<li class="media">
                            <div class="media-left">
                                <img src="${img}" class="img-circle img-sm" alt="">
                            </div>

                            <div class="media-body">
                                <a onclick="set_Notify(${res.data[i].transfer_id},'TR')" href="index.php?p=transfer&id=${res.data[i].transfer_id}" class="media-heading">
                                    <span class="text-semibold">${Translation('Transfer No.')} : ${res.data[i].transfer_number}</span>
                                    <span class="media-annotation pull-right">${Translation('Days')} : ${res.data[i].days}</span>
                                
                                </a>

                                <span class="text-muted">${res.data[i].stock_name}
                                 ${Translation('Request Date')} : ${res.data[i].request_date_start}
                                 </span>

                            </div>
                        </li>`;
            }
            

            $('#notify_msg').html(opt);

         

            
            

        }else{

          swal({
                  title: Translation("خطأ"),
                  text: Translation(res.data),
                  confirmButtonColor: "#2196F3",
                  type: "error"
              });

        }
        
      }
  });

}

function set_Notify(id,typ){

  $.ajax({
      url: "models/crul_notify.php",
      type:"POST",
      dataType : "JSON",
      data: {   "type":"set_notify",
                id:id,
                notifier:typ},
      complete:function(){
        
      },
      beforeSend:function(){
        
      },
      success: function(res) {

        return;
        
      }
  });

}

function Checks(id,types=null,min=null,max=null,badge=null){
        var name = $("#"+id).val();
        var placeholder = $("#"+id).attr('placeholder');
        if(types == null){  // it mean string

              if(min !=null && max !=null){
                  if(name =='' || name.length < min || name.length > max){
                    $("#"+id).closest('.form-group').removeClass('has-success');
                    $("#"+id).closest('.form-group').addClass('has-error');

                    noty({
                            width: 200,
                            text: Translation("الرجاء قم بادخال قيمة في الحقل لا تقل عن ")+ min + Translation(" ولا تزيد عن " + max),
                            type: 'error',
                            dismissQueue: true,
                            timeout: 3000,
                            layout: 'topRight',
                      });
                    return false;
                  }else{
                      $("#"+id).closest('.form-group').removeClass('has-error');
                      $("#"+id).closest('.form-group').addClass('has-success');
                      return true;
                  }
              }else if(min !=null && max ==null){
                  if(name ==''  || name.length < min ){
                    $("#"+id).closest('.form-group').removeClass('has-success');
                    $("#"+id).closest('.form-group').addClass('has-error');

                    noty({
                            width: 200,
                            text: Translation("الرجاء قم بادخال قيمة في الحقل لا تقل عن ")+ min ,
                            type: 'error',
                            dismissQueue: true,
                            timeout: 3000,
                            layout: 'topRight',
                      });
                    return false;
                  }else{
                      $("#"+id).closest('.form-group').removeClass('has-error');
                      $("#"+id).closest('.form-group').addClass('has-success');
                      return true;
                  }
              }else if(min ==null && max !=null){
                  if(name ==''  ||  name.length > max){
                    $("#"+id).closest('.form-group').removeClass('has-success');
                    $("#"+id).closest('.form-group').addClass('has-error');

                    noty({
                            width: 200,
                            text: Translation("الرجاء قم بادخال قيمة في الحقل لا تزيد عن ") + max,
                            type: 'error',
                            dismissQueue: true,
                            timeout: 3000,
                            layout: 'topRight',
                      });
                    return false;
                  }else{
                      $("#"+id).closest('.form-group').removeClass('has-error');
                      $("#"+id).closest('.form-group').addClass('has-success');
                      return true;
                  }
              }else{

                  if(name ==''){
                    $("#"+id).closest('.form-group').removeClass('has-success');
                    $("#"+id).closest('.form-group').addClass('has-error');

                    noty({
                            width: 200,
                            text: Translation("حقل ") + placeholder + Translation(" لا يجب ان يبقى فاغ"),
                            type: 'error',
                            dismissQueue: true,
                            timeout: 3000,
                            layout: 'topRight',
                      });
                    return false;
                  }else{
                      $("#"+id).closest('.form-group').removeClass('has-error');
                      $("#"+id).closest('.form-group').addClass('has-success');
                      return true;
                  }

              }

        }else if(types == 'No'){  // it mean numbers

              if(min !=null && max !=null){
                  if(name !='' && isNaN(name) || name < min || name > max){
                    $("#"+id).closest('.form-group').removeClass('has-success');
                    $("#"+id).closest('.form-group').addClass('has-error');

                    noty({
                            width: 200,
                            text: Translation("الرجاء قم بادخال قيمة عددية بين")+ min + Translation(" و ") + max,
                            type: 'error',
                            dismissQueue: true,
                            timeout: 3000,
                            layout: 'topRight',
                      });
                    return false;
                  }else{
                      $("#"+id).closest('.form-group').removeClass('has-error');
                      $("#"+id).closest('.form-group').addClass('has-success');
                      return true;
                  }
              }else if(min !=null && max ==null && badge !=null){
                  if(name !='' && isNaN(name) || name < min ){
                    $("#"+id).removeClass('badge-primary');
                    $("#"+id).addClass('badge-warning');

                    noty({
                            width: 200,
                            text: Translation("الرجاء قم بادخال قيمة عددية اكبر من ")+ min,
                            type: 'error',
                            dismissQueue: true,
                            timeout: 3000,
                            layout: 'topRight',
                      });
                    return false;
                  }else{
                      $("#"+id).removeClass('badge-warning');
                      $("#"+id).addClass('badge-primary');
                      return true;
                  }


                }else if(min !=null && max ==null){
                  if(name !='' && isNaN(name) || name < min ){
                    $("#"+id).closest('.form-group').removeClass('has-success');
                    $("#"+id).closest('.form-group').addClass('has-error');
                    
                    noty({
                            width: 200,
                            text: Translation("الرجاء قم بادخال قيمة عددية اكبر او تساوي ")+ min + Translation(" في حقل ") + placeholder,
                            type: 'error',
                            dismissQueue: true,
                            timeout: 3000,
                            layout: 'topRight',
                      });
                    return false;
                  }else{
                      $("#"+id).closest('.form-group').removeClass('has-error');
                      $("#"+id).closest('.form-group').addClass('has-success');
                      return true;
                  }
              }else if(min ==null && max !=null){
                  if(name !='' && isNaN(name) ||  name > max){
                    $("#"+id).closest('.form-group').removeClass('has-success');
                    $("#"+id).closest('.form-group').addClass('has-error');

                    noty({
                            width: 200,
                            text: Translation("الرجاء ادخال قيمة عددية اقل من ") + max,
                            type: 'error',
                            dismissQueue: true,
                            timeout: 3000,
                            layout: 'topRight',
                      });
                    return false;
                  }else{
                      $("#"+id).closest('.form-group').removeClass('has-error');
                      $("#"+id).closest('.form-group').addClass('has-success');
                      return true;
                  }
              }else{

                  if(name !='' && isNaN(name)){
                    $("#"+id).closest('.form-group').removeClass('has-success');
                    $("#"+id).closest('.form-group').addClass('has-error');

                    noty({
                            width: 200,
                            text: Translation("الرجاء ادخال قيمة عددية"),
                            type: 'error',
                            dismissQueue: true,
                            timeout: 3000,
                            layout: 'topRight',
                      });
                    return false;
                  }else{
                      $("#"+id).closest('.form-group').removeClass('has-error');
                      $("#"+id).closest('.form-group').addClass('has-success');
                      return true;
                  }

              }

        }
}


$(document).ready(function() {
    
    // get_user_permission();
    get_Notify();

   

    $(".stop_enter").on("keypress", function (e) {
        
        if (e.keyCode == 13) {
            e.preventDefault();
            $.autotab.next();
            
        }
    });

    $(".page-content").on("keyup",".bootstrap-select", function (e) {
        
        if (e.keyCode == 9 || e.which ==9) {
           
            // e.preventDefault();
            console.log($(this).find('ul li.active a').html())
         
            $(this).find('div.bs-searchbox input.form-control').val('');
            
            if($(this).find('ul li.active').attr('data-original-index') !="0"){
              
              $(this).find('ul li.selected a').trigger('click');
              $(this).find('ul li.active a').trigger('click');
              
              $(this).find('ul li.active').removeClass('active');
              $(this).find('ul li.selected').addClass('active');
              
            }
        }
    })

    $(document).on('keydown', '.select2', function(e) {
        if (e.originalEvent && e.which == 40) {
            e.preventDefault();
            $(this).siblings('select').select2('open');
        }
    });

    $(document).on('focus', '.select2-selection.select2-selection--single', function (e) {
      $(this).closest(".select2-container").siblings('select:enabled').select2('open');
    });

    // steal focus during close - only capture once and stop propogation
    $('select.select2').on('select2:closing', function (e) {
      $(e.target).data("select2").$selection.one('focus focusin', function (e) {
        e.stopPropagation();
      });
    });

    $("#add_table").on('keyup',".clone_row", function (e) {
          
          if (e.keyCode == 9 || e.which ==9) {
            e.preventDefault();
            $(this).trigger('click');
          
          }else if (e.keyCode == 13 || e.which ==13) {
            e.preventDefault();
            $("#total_qty").focus();
          }
    });

    $("#add_table").on('keypress', '.stop_enter', function (e) {
        if (e.keyCode == 13) {
            e.preventDefault();
            $.autotab.next();
            
        }
          
          
    });
   


});

 

  

$(function() {
 


}); 


function round(value, decimals) {
  return Number(Math.round(value+'e'+decimals)+'e-'+decimals);
}






  function currency_format_display_no_space(cash,cur='$'){
    // console.log(cash);
    if(isNaN(cash) || cash == null || cash==0){
      return  0 + " $";
    }else{
      //return cur +" "+ cash;
      
      var value = parseFloat(cash);
      var num =   value.toFixed(2).replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,") +cur;
      return num;
      //return cur +" "+ value.toFixed(2).replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
    }

  }


  function currency_format(cash,cur='$'){
    // console.log(cash);
    if(isNaN(cash) || cash == null || cash==0 || cash==undefined){
      return "$ "+ 0;
    }else{
      return cur +" "+ parseFloat(cash).toFixed(2);
      
     // var value = parseFloat(cash);
     // var num = '$ ' + value.toFixed(2).replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
     // return num;
    }

  }


  function escape_notes(){
    $("span[data-popup='tooltip']").each(function(){
        var deco = $(this).attr('data-original-title');
        deco = decodeURIComponent(deco);
        $(this).attr('data-original-title',deco);
     }); 
  }

  function escapeHtml(unsafe) {
    
    if(unsafe == null || unsafe=='' || unsafe==undefined){
      return unsafe;
    }else{
      safe = unsafe.replace(/%/g, "&_25_;");
      safe = safe.replace(/\\/g, "&_5C_;");
      safe = safe.replace(/"/g, "&_quot_;");
      safe = safe.replace(/'/g, "&#_039_;");
      safe = safe.replace(/\n/g, "&#_013_;");
      //alert(safe)
      return safe;
    }

    
 }

 function decodeURIComponent_back(unsafe) {
    if(unsafe == null || unsafe=='' || unsafe==undefined){
      return unsafe;
    }else{
      safe = unsafe.replace(/&_25_;/g, "%");
      safe = safe.replace(/&_5C_;/g, "\\");
      safe = safe.replace(/&_quot_;/g, '"');
      safe = safe.replace(/&#_039_;/g, "'");
      safe = safe.replace(/&#_013_;/g, "\n");

      return safe;
    }
    
    // alert(safe)
    
 }

 Date.dateDiff = function(datepart, fromdate, todate) {
    datepart = datepart.toLowerCase();
    var diff = todate - fromdate;
    var divideBy = { w:604800000,
                     d:86400000,
                     h:3600000,
                     n:60000,
                     s:1000 };

    return Math.floor( diff/divideBy[datepart]);
  }


  function getQueryVariable(variable) {
      var query = window.location.search.substring(1);
      var vars = query.split("&");
      for (var i=0;i<vars.length;i++) {
        var pair = vars[i].split("=");
        if (pair[0] == variable) {
          return pair[1];
        }
      }
      return 'not';
  }

 
$(function() {
  // tag input

  // Basic initialization
    $('.tokenfield').tokenfield();
  //
    // Teal
    //

    // Add class on init
    $('.tokenfield-teal').on('tokenfield:initialize', function (e) {
        $(this).parent().find('.token').addClass('bg-teal')
    });

    // Initialize plugin
    $('.tokenfield-teal').tokenfield();

    // Add class when token is created
    $('.tokenfield-teal').on('tokenfield:createdtoken', function (e) {
        $(e.relatedTarget).addClass('bg-teal')
    });

    // ========================================
    //
    // Tags input
    //
    // ========================================


    // Display values
    $('.tags-input, [data-role="tagsinput"], .tagsinput-max-tags, .tagsinput-custom-tag-class').on('change', function(event) {
        var $element = $(event.target),
            $container = $element.parent().parent('.content-group');

        if (!$element.data('tagsinput'))
        return;

        var val = $element.val();
        if (val === null)
        val = "null";
    
        $('pre.val > code', $container).html( ($.isArray(val) ? JSON.stringify(val) : "\"" + val.replace('"', '\\"') + "\"") );
        $('pre.items > code', $container).html(JSON.stringify($element.tagsinput('items')));
        Prism.highlightAll();
    }).trigger('change');



    // Basic examples
    // ------------------------------

    // Basic initialization
    $('.tags-input').tagsinput();


    // Allow dublicates
    $('.tags-input-dublicates').tagsinput({
        allowDuplicates: true
    });


    // Set maximum allowed tags
    $('.tagsinput-max-tags').tagsinput({
        maxTags: 5
    });


    // Custom tag class
    $('.tagsinput-custom-tag-class').tagsinput({
        tagClass: function(item){
            return 'label bg-success';
        }
    });

});